package doABC;

import java.nio.ByteBuffer;
import java.util.*;
import FlashReader.*;

public class ExceptionInfo extends SwfTools{
	
	private int id;
	private	AbcFile abc;
	private int start;
	private int end;
	//struktory
	private int from;
	private int to;
	private int target;
	private int exc_type;
	private int var_name;
	
	
	public ExceptionInfo(ByteBuffer bbuf,AbcFile abc){
		super();
		this.abc = abc;
		exception_info(bbuf);
		abc.ENexception_info.add(this);
		id = abc.ENexception_info.size()-1;
	}
	
	public ExceptionInfo(AbcFile abc,int from,int to,int target, int exc_type,int var_name){
		super();
		this.abc = abc;
		abc.ENexception_info.add(this);
		id = abc.ENexception_info.size()-1;
		this.from=from;
		this.to=to;
		this.target=target;
		this.exc_type=exc_type;
		this.var_name=var_name;
		
	}
	
	public void exception_info(ByteBuffer bbuf){
		try{
		start = bbuf.position();
			
		from = unsigned30int(bbuf);

		to = unsigned30int(bbuf);
		
		target = unsigned30int(bbuf);
		
		exc_type = unsigned30int(bbuf);
		
		var_name = unsigned30int(bbuf);
		
		end = bbuf.position()-1;
		} catch (Exception e) {e.printStackTrace();}
	}

	public ArrayList<Byte> toByteCode(){
		ArrayList<Byte> result = new ArrayList<Byte>();
		
			for( byte b : getUI32(from))
				result.add(b);
		
			for( byte b : getUI32(to))
				result.add(b);

			for( byte b : getUI32(target))
				result.add(b);
			
			for( byte b : getUI32(exc_type))
				result.add(b);
			
			for( byte b : getUI32(var_name))
				result.add(b);
		
		return result;
	}


	//getters
	
	public int getId() {
		return id;
	}

	public int getFrom() {
		return from;
	}

	public int getTo() {
		return to;
	}

	public int getTarget() {
		return target;
	}

	public int getExc_type() {
		return exc_type;
	}
	
	public String getExc_type_string() {
		abc.getConstant_pool().setZeroString("*");
		return abc.getConstant_pool().getStrings_string().get(exc_type);
	}
	
	public int getVar_name() {
		return var_name;
	}
	
	public String getVar_name_string() {
		abc.getConstant_pool().setZeroString("NO_NAME");
		return  abc.getConstant_pool().getStrings_string().get(var_name);
	}

	public void setTarget(int target) {
		this.target = target;
	}


	//setters

	
	public void setId(int id) {
		this.id = id;
		out("ok");
	}

	public void setVar_name(int var_name) {
		this.var_name = var_name;
		out("ok");
	}
	
	public void setExc_type(int exc_type) {
		this.exc_type = exc_type;
		out("ok");
	}

	public void setFrom(int from) {
		this.from = from;
		out("ok");
	}

	public void setTo(int to) {
		this.to = to;
		out("ok");
	}

	
	//toStrings
	
	public String String(){
		
		StringBuffer wynik = new StringBuffer();
		wynik.append( "\n---#--- exception_info "+SWF.msgs.getString("Position")+": " + start + "\n" );
		
		wynik.append( "from: " + from+"\n" );
		
		wynik.append( "to: " + to+"\n" );
		
		wynik.append( "target: " + target+"\n" );
		
		wynik.append( "exc_type: " + exc_type+"\n" );
		
		wynik.append( "var_name: " + var_name+"\n" );
			
		wynik.append( "\n---!!--- "+SWF.msgs.getString("Position")+":  "+end );		
		return wynik.toString();
		
	}
	
	public String toString(){
		String wynik ="";
		wynik+="ExceptionInfo id"+ id + " "+ start+ " - " + end;
		return wynik;
	}

	
}

